
class Workflow:
    def __init__(
        self,
        name: str,
        llm_config,
        dataset: DatasetType,
    ) -> None:
        self.name = name
        self.dataset = dataset
        self.llm = create_llm_instance(llm_config)
        self.llm.cost_manager = CostManager()
        self.custom = operator.Custom(self.llm)
        self.sc_ensemble = operator.ScEnsemble(self.llm)

    async def __call__(self, problem: str):
        """
        Implementation of the workflow
        """
        ideas = []
        for _ in range(3):  # Generate 3 ideas
            idea = await self.custom(input=problem, instruction=prompt_custom.GENERATE_IDEA)
            elaborated_idea = await self.custom(input=problem + f"\nInitial idea: {idea['response']}", instruction=prompt_custom.ELABORATE_IDEA)
            ideas.append(elaborated_idea['response'])
        
        best_idea = await self.sc_ensemble(solutions=ideas, problem=problem)
        
        evaluation = await self.custom(input=best_idea['response'], instruction=prompt_custom.EVALUATE_RESEARCH)
        
        final_solution = await self.custom(input=best_idea['response'] + f"\nEvaluation: {evaluation['response']}", instruction=prompt_custom.REFINE_PROPOSAL)
        
        return final_solution['response'], self.llm.cost_manager.total_cost
